<?php
$result = $_SESSION['comparison_result'];
$matches = $result['matches'] ?? [];
$unmatchedBank = $result['unmatched_bank'] ?? [];
$unmatchedStock = $result['unmatched_stock'] ?? [];
?>

<div class="results-summary">
    <div class="summary-item">
        <span class="label">Banka Dosyası Kayıt Sayısı:</span>
        <span class="value"><?php echo $result['bank_count']; ?></span>
    </div>
    <div class="summary-item">
        <span class="label">ML Dosyası Kayıt Sayısı:</span>
        <span class="value"><?php echo $result['stock_count']; ?></span>
    </div>
    <div class="summary-item">
        <span class="label">Eşleşen Kayıt Sayısı:</span>
        <span class="value highlight"><?php echo count($matches); ?></span>
    </div>
    <div class="summary-item">
        <span class="label">ML'de Olmayan Banka Kayıtları:</span>
        <span class="value unmatched"><?php echo count($unmatchedBank); ?></span>
    </div>
    <div class="summary-item">
        <span class="label">Banka'da Olmayan ML Kayıtları:</span>
        <span class="value unmatched"><?php echo count($unmatchedStock); ?></span>
    </div>
</div>

<?php 
// Tüm kayıtları birleştir
$allRecords = [];

// Eşleşen kayıtları ekle
foreach ($matches as $match) {
    $allRecords[] = [
        'type' => 'match',
        'bank_row' => $match['bank_row'],
        'stock_row' => $match['stock_row'],
        'bank_account' => $match['bank_account'],
        'stock_account' => $match['stock_account'],
        'amount' => $match['amount'],
        'similarity' => $match['similarity'],
        'status' => 'Eşleşti'
    ];
}

// ML'de olmayan banka kayıtlarını ekle
foreach ($unmatchedBank as $record) {
    $allRecords[] = [
        'type' => 'unmatched_bank',
        'bank_row' => $record['bank_row'],
        'stock_row' => '-',
        'bank_account' => $record['bank_account'],
        'stock_account' => '-',
        'amount' => $record['amount'],
        'similarity' => '-',
        'status' => isset($record['filter_reason']) ? $record['filter_reason'] : 'ML\'de bulunamadı'
    ];
}

// Banka'da olmayan ML kayıtlarını ekle
foreach ($unmatchedStock as $record) {
    $allRecords[] = [
        'type' => 'unmatched_stock',
        'bank_row' => '-',
        'stock_row' => $record['stock_row'],
        'bank_account' => '-',
        'stock_account' => $record['stock_account'],
        'amount' => $record['amount'],
        'similarity' => '-',
        'status' => isset($record['filter_reason']) ? $record['filter_reason'] : 'Banka\'da bulunamadı'
    ];
}

// Satır numarasına göre sırala
usort($allRecords, function($a, $b) {
    $aRow = ($a['bank_row'] !== '-') ? $a['bank_row'] : $a['stock_row'];
    $bRow = ($b['bank_row'] !== '-') ? $b['bank_row'] : $b['stock_row'];
    return $aRow - $bRow;
});
?>

<?php if (count($allRecords) > 0): ?>
    <div class="results-section">
        <h3>Tüm Kayıtlar (Birleşik Görünüm)</h3>
        <div class="table-container">
            <table class="results-table">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Banka Satır</th>
                        <th>ML Satır</th>
                        <th>Banka Hesap Adı</th>
                        <th>ML Hesap Adı</th>
                        <th>Tutar</th>
                        <th>Benzerlik</th>
                        <th>Durum</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($allRecords as $index => $record): ?>
                        <tr class="<?php echo $record['type']; ?>">
                            <td><?php echo $index + 1; ?></td>
                            <td><?php echo $record['bank_row']; ?></td>
                            <td><?php echo $record['stock_row']; ?></td>
                            <td class="account-name"><?php echo htmlspecialchars($record['bank_account']); ?></td>
                            <td class="account-name"><?php echo htmlspecialchars($record['stock_account']); ?></td>
                            <td class="amount"><?php 
                                if ($record['amount'] < 0) {
                                    echo '-' . number_format(abs($record['amount']), 2) . ' ₺';
                                } else {
                                    echo number_format($record['amount'], 2) . ' ₺';
                                }
                            ?></td>
                            <td class="similarity"><?php echo $record['similarity']; ?></td>
                            <td class="status"><?php echo $record['status']; ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
<?php endif; ?>

<?php if (count($matches) == 0 && count($unmatchedBank) == 0 && count($unmatchedStock) == 0): ?>
    <div class="no-results">
        <p>Hiç kayıt bulunamadı.</p>
        <p>Lütfen dosyalarınızda tutar sütunlarının doğru formatta olduğundan emin olun.</p>
    </div>
<?php endif; ?>